package com.qboxus.tictic.viewModels

import android.content.Context
import android.content.SharedPreferences
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.viewModelScope
import com.qboxus.tictic.apiclasses.ApiResponce
import com.qboxus.tictic.repositories.UserRepository
import com.qboxus.tictic.simpleclasses.Functions
import com.qboxus.tictic.simpleclasses.Variables
import kotlinx.coroutines.launch
import org.json.JSONObject

class DeleteAccountViewModel(
    private val context: Context,
    private val userRepository: UserRepository

) : ViewModel(){


    lateinit var sharedPreferences: SharedPreferences
    init {
        sharedPreferences=Functions.getSharedPreference(context)
    }


    val _deleteUserLiveData: MutableLiveData<ApiResponce<String>> = MutableLiveData()
    val deleteUserLiveData: LiveData<ApiResponce<String>> get() = _deleteUserLiveData

    fun deleteUserAccount(){
        viewModelScope.launch {

            val param = JSONObject()
            userRepository.callApiDeleteUser(param, _deleteUserLiveData)
        }
    }




}

class DeleteAccountFactory(
    private val context: Context,
    private val userRepository: UserRepository
) : ViewModelProvider.Factory {
    override fun <T : ViewModel> create(modelClass: Class<T>): T {
        if (modelClass.isAssignableFrom(DeleteAccountViewModel::class.java)) {
            return DeleteAccountViewModel(context,userRepository) as T
        }
        throw IllegalArgumentException("Unknown ViewModel class")
    }
}